package elaborator;

import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

import elaborator.tests.TestPlanetDatabase;

/**
 * Qua è un casino.
 * 
 * @author koelio
 * 
 */
public class Searcher {
	private static final int AFFINITY = 4;
	TestPlanetDatabase database;
	String myplanet;

	public Searcher(TestPlanetDatabase database) {
		this.database = database;
	}

	public void searchPlanetAffinity(String myplanet) {
		/**
		 * Carico tutto il database passatomi
		 */
		Map<String, Map<Double, String>> map = database.getDatabase();

		/**
		 * Tutti i pianeti del database
		 */
		Set<String> planets = map.keySet();// pianeti in database

		/**
		 * Database che verrà ordinato
		 */
		Map<String, Map<Double, String>> mapOrdered = new TreeMap<String, Map<Double, String>>();

		/**
		 * Ordinamento delle Map<Percentuale, Elementi> del database (copia nel treeMap di prima)
		 */
		for (String planet : planets) {
			mapOrdered
					.put(planet, new TreeMap<Double, String>(map.get(planet)));
		}
		// System.out.println(mapOrdered); debug

		// System.out.println(map); debug

		/**
		 * nome del mio pianeta
		 */
		this.myplanet = myplanet;
		/**
		 * Composizione mio pianeta
		 */
		Map<Double, String> mycomposition = map.get(myplanet);

		/**
		 * composizione del mio pianeta Ordinata
		 */
		SortedMap<Double, String> myCompOrderd = new TreeMap<Double, String>(
				mycomposition);

		/**
		 * Algoritmo ultra magico di ricerca. In poche parole, per evitare il
		 * suicidio, funziona così: For ogni pianeta di tutti i Planets uso un
		 * Flag che mi conta quanti elementi coincidono. For ogni Mia percentuale
		 * di elementi del Mio pianeta vedo Tutte le percentuali del pianeta di
		 * prima. Data una mia percentuale per ogni percentuale controllo se
		 * corrisponde all'elemento, se sì il flag++. Quindi, in sostanza, vedo
		 * quanti elementi in comune ci sono tra il mio pianeta e tutti gli
		 * altri e poi li stampo. Bisogna sapere che le Mappe sono ordinate
		 * crescenti quindi ci sono due problemi: invertire la crescenza in
		 * decrescenza e poi fare in modo che vengano contate solo le prime cinque
		 * iterazioni delle Mie percentuali (secondo for) e anche solo (o almeno
		 * solo qui) cinque percentuali degli altri pianeti data la Mia
		 * percentuale (terzo for). Altrimenti l'affinità è data solo per il
		 * nuemro di elementi in comune
		 * 
		 */
		for (String planet : planets) {
			int flag = 0;
			for (Double mypercent : myCompOrderd.keySet()) {
				Set<Double> percents = mapOrdered.get(planet).keySet();
				for (Double percent : percents) {
					if (myCompOrderd.get(mypercent).equalsIgnoreCase(
							mapOrdered.get(planet).get(percent))) {
						flag++;
					}
				}
			}

			if (flag >= AFFINITY) {
				System.out.println("\n" + planet + " è affine a " + myplanet
						+ " per " + flag + " elementi");
			}
		}

	}
}
